/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Group;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;

public class ElementPolygon
extends Element
implements Data {
    private boolean closed = true;
    private double[][] coordinates = new double[0][0];
    private ActionListener listener = null;
    private int[] aPoints = null;
    private int[] bPoints = null;
    protected int datasetID = this.hashCode();

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void setData(double[][] dArray) {
        int n;
        if (dArray == null) {
            return;
        }
        if (this.coordinates.length != dArray.length) {
            n = dArray.length;
            this.coordinates = new double[n][2];
            this.aPoints = new int[n];
            this.bPoints = new int[n];
        }
        n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            System.arraycopy(dArray[n], 0, this.coordinates[n], 0, 2);
            ++n;
        }
        this.setElementChanged();
    }

    public void setData(double[] dArray, double[] dArray2) {
        int n = Math.max(dArray.length, dArray2.length);
        if (this.coordinates.length != n) {
            this.coordinates = new double[n][2];
            this.aPoints = new int[n];
            this.bPoints = new int[n];
        }
        if (dArray.length == dArray2.length) {
            int n2 = 0;
            while (n2 < n) {
                this.coordinates[n2][0] = dArray[n2];
                this.coordinates[n2][1] = dArray2[n2];
                ++n2;
            }
        } else {
            double d = dArray[dArray.length - 1];
            double d2 = dArray2[dArray2.length - 1];
            int n3 = 0;
            while (n3 < n) {
                this.coordinates[n3][0] = n3 < dArray.length ? dArray[n3] : d;
                this.coordinates[n3][1] = n3 < dArray2.length ? dArray2[n3] : d2;
                ++n3;
            }
        }
        this.setElementChanged();
    }

    public double[][] getData() {
        double[][] dArray = new double[this.coordinates.length][2];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, dArray[n], 0, 2);
            ++n;
        }
        return dArray;
    }

    public double[][] getDataArray() {
        return this.coordinates;
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = new double[2][this.coordinates.length];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            dArray[0][n] = this.coordinates[n][0];
            dArray[1][n] = this.coordinates[n][1];
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"x", "y"};
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getLineColor()};
    }

    @Override
    public Color[] getFillColors() {
        Paint paint = this.getStyle().getFillColor();
        if (paint instanceof Color) {
            return new Color[]{Color.BLACK, (Color)paint};
        }
        return new Color[]{Color.BLACK, Color.BLUE};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    @Override
    protected void updateExtrema() {
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        double[] dArray = new double[2];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, dArray, 0, 2);
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
            this.compareToAllExtrema(dArray[0], dArray[1]);
            ++n;
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(drawingPanel);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.getStyle().getLineStroke());
        Color color = this.getStyle().getLineColor();
        if (this.closed) {
            Paint paint = this.getStyle().getFillColor();
            if (paint != null && this.getStyle().isDrawingFill()) {
                graphics2D.setPaint(paint);
                graphics2D.fillPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            }
            if (color != null && this.getStyle().isDrawingLines()) {
                graphics2D.setColor(color);
                graphics2D.drawPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            }
        } else {
            graphics2D.setColor(color);
            graphics2D.drawPolyline(this.aPoints, this.bPoints, this.aPoints.length);
        }
    }

    private double[] getHotSpotOfPoint(int n) {
        double[] dArray = new double[]{this.coordinates[n][0], this.coordinates[n][1]};
        this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
        return dArray;
    }

    @Override
    public void updateHotSpot(InteractionTarget interactionTarget, double[] dArray) {
        if (interactionTarget.getEnabled() == 4) {
            return;
        }
        Group group = this.getGroup();
        int n = (Integer)interactionTarget.getDataObject();
        block2 : switch (interactionTarget.getType()) {
            case 0: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray2 = this.getHotSpotOfPoint(n);
                    switch (interactionTarget.getEnabled()) {
                        case 2: {
                            group.setX(group.getX() + dArray[0] - dArray2[0]);
                            break block2;
                        }
                        case 3: {
                            group.setY(group.getY() + dArray[1] - dArray2[1]);
                            break block2;
                        }
                    }
                    group.setXY(group.getX() + dArray[0] - dArray2[0], group.getY() + dArray[1] - dArray2[1]);
                    break;
                }
                double[] dArray3 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray3);
                double[] dArray4 = new double[]{this.coordinates[n][0], this.coordinates[n][1]};
                dArray4[0] = dArray4[0] * this.getSizeX();
                dArray4[1] = dArray4[1] * this.getSizeY();
                this.getTheTransformation().transform(dArray4, 0, dArray4, 0, 1);
                switch (interactionTarget.getEnabled()) {
                    case 2: {
                        this.setX(dArray3[0] - dArray4[0]);
                        break block2;
                    }
                    case 3: {
                        this.setY(dArray3[1] - dArray4[1]);
                        break block2;
                    }
                }
                this.setXY(dArray3[0] - dArray4[0], dArray3[1] - dArray4[1]);
                break;
            }
            case 1: {
                if (group != null && interactionTarget.getAffectsGroup()) {
                    double[] dArray5 = (double[])dArray.clone();
                    dArray5[0] = dArray5[0] - group.getX();
                    dArray5[1] = dArray5[1] - group.getY();
                    try {
                        group.getTheTransformation().inverseTransform(dArray5, 0, dArray5, 0, 1);
                    }
                    catch (Exception exception) {}
                    double[] dArray6 = new double[]{this.coordinates[n][0], this.coordinates[n][1]};
                    this.elementDirectTransformations(dArray6);
                    dArray5[0] = dArray6[0] != 0.0 ? dArray5[0] / dArray6[0] : group.getX();
                    dArray5[1] = dArray6[1] != 0.0 ? dArray5[1] / dArray6[1] : group.getY();
                    switch (interactionTarget.getEnabled()) {
                        case 2: {
                            group.setSizeX(dArray5[0]);
                            break block2;
                        }
                        case 3: {
                            group.setSizeY(dArray5[1]);
                            break block2;
                        }
                    }
                    group.setSize(dArray5);
                    break;
                }
                double[] dArray7 = (double[])dArray.clone();
                this.groupInverseTransformations(dArray7);
                dArray7[0] = dArray7[0] - this.getX();
                dArray7[1] = dArray7[1] - this.getY();
                try {
                    this.getTheTransformation().inverseTransform(dArray7, 0, dArray7, 0, 1);
                }
                catch (Exception exception) {}
                this.coordinates[n][0] = dArray7[0];
                this.coordinates[n][1] = dArray7[1];
                this.setNeedToProject(true);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        int n3;
        if (!this.targetPosition.isEnabled() && !this.targetSize.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(drawingPanel);
        }
        if ((n3 = this.getStyle().getSensitivity()) <= 0) {
            n3 = 1;
        }
        int n4 = 0;
        int n5 = this.aPoints.length;
        while (n4 < n5) {
            if (Math.abs(this.aPoints[n4] - n) < n3 && Math.abs(this.bPoints[n4] - n2) < n3) {
                if (this.targetPosition.isEnabled()) {
                    this.targetPosition.setDataObject(new Integer(n4));
                    return this.targetPosition;
                }
                if (this.targetSize.isEnabled()) {
                    this.targetSize.setDataObject(new Integer(n4));
                    return this.targetSize;
                }
            }
            ++n4;
        }
        return null;
    }

    private void projectPoints(DrawingPanel drawingPanel) {
        AffineTransform affineTransform = this.getPixelTransform(drawingPanel);
        double[] dArray = new double[2];
        int n = 0;
        int n2 = this.coordinates.length;
        while (n < n2) {
            System.arraycopy(this.coordinates[n], 0, dArray, 0, 2);
            affineTransform.transform(dArray, 0, dArray, 0, 1);
            this.aPoints[n] = (int)dArray[0];
            this.bPoints[n] = (int)dArray[1];
            ++n;
        }
        this.setNeedToProject(false);
    }
}

