/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.io.File;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoIO;

public class VideoFileFilter
extends FileFilter
implements Comparable<VideoFileFilter> {
    String[] extensions;
    String type = "Video";

    public VideoFileFilter() {
    }

    public VideoFileFilter(String string, String[] stringArray) {
        if (string != null && stringArray != null && stringArray.length > 0) {
            this.type = string;
            this.extensions = stringArray;
        }
    }

    @Override
    public boolean accept(File file) {
        block6: {
            block5: {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                if (this.extensions == null) break block5;
                String string = VideoIO.getExtension(file);
                if (string == null) break block6;
                String[] stringArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    if (string.toLowerCase().equals(string2.toLowerCase())) {
                        return true;
                    }
                    ++n2;
                }
                break block6;
            }
            for (FileFilter fileFilter : VideoIO.singleVideoTypeFilters) {
                if (!fileFilter.accept(file)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        String string = MediaRes.getString(String.valueOf(this.type.toUpperCase()) + "FileFilter.Description");
        if (this.extensions != null) {
            string = String.valueOf(string) + " (";
            int n = 0;
            while (n < this.extensions.length) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + "." + this.extensions[n];
                ++n;
            }
            string = String.valueOf(string) + ")";
        }
        return string;
    }

    public String getDefaultExtension() {
        if (this.extensions != null) {
            return this.extensions[0];
        }
        for (VideoFileFilter videoFileFilter : VideoIO.singleVideoTypeFilters) {
            String string = videoFileFilter.getDefaultExtension();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String[] getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (VideoFileFilter videoFileFilter : VideoIO.singleVideoTypeFilters) {
            String[] stringArray;
            String[] stringArray2 = stringArray = videoFileFilter.getExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                treeSet.add(string);
                ++n2;
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public String getContainerType() {
        return this.type;
    }

    @Override
    public int compareTo(VideoFileFilter videoFileFilter) {
        return this.getDescription().compareTo(videoFileFilter.getDescription());
    }
}

