/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.HermiteIntervalData;

public class BootstrapIntervalData
extends HermiteIntervalData {
    private static final double ALPHA = 0.25;
    private static final double bt1_den = 0.1875;
    private static final double bt1_cf1 = 0.3125;
    private static final double bt1_cf0 = -0.1875;
    private static final double bt1_cys = -1.125;
    protected ODE mODE;
    private double[] state_bt1 = null;
    private double[] rate_bt1;
    private double[] bt1_c2;
    private double[] bt1_c3;
    private double[] bt1_c4;

    public BootstrapIntervalData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, ODE oDE) {
        super(dArray, dArray2, dArray3, dArray4);
        this.mODE = oDE;
        this.prepareFirstBootstrap();
    }

    @Override
    public double interpolate(double d, int n) {
        double d2 = (d - this.getLeft()) / this.mDeltaTime;
        return this.mLeftState[n] + d2 * (this.mDeltaTime * this.mLeftRate[n] + d2 * (this.bt1_c2[n] + d2 * (this.bt1_c3[n] + d2 * this.bt1_c4[n])));
    }

    @Override
    public double[] interpolate(double d, double[] dArray, int n, int n2) {
        this.bootstrap1((d - this.getLeft()) / this.mDeltaTime, dArray, n, n2);
        return dArray;
    }

    protected void bootstrap1(double d, double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            dArray[n4] = this.mLeftState[n3] + d * (this.mDeltaTime * this.mLeftRate[n3] + d * (this.bt1_c2[n3] + d * (this.bt1_c3[n3] + d * this.bt1_c4[n3])));
            ++n3;
            ++n4;
        }
    }

    private void prepareFirstBootstrap() {
        int n = this.mTimeIndex + 1;
        if (this.state_bt1 == null) {
            this.state_bt1 = new double[n];
            this.rate_bt1 = new double[n];
            this.bt1_c2 = new double[n];
            this.bt1_c3 = new double[n];
            this.bt1_c4 = new double[n];
        }
        super.hermite(0.25, this.state_bt1, 0, this.mTimeIndex);
        this.state_bt1[this.mTimeIndex] = this.getLeft() + 0.25 * this.mDeltaTime;
        this.mODE.getRate(this.state_bt1, this.rate_bt1);
        int n2 = 0;
        while (n2 < n) {
            double d = this.mRightState[n2] - this.mLeftState[n2];
            double d2 = this.mDeltaTime * this.mLeftRate[n2];
            double d3 = this.mDeltaTime * this.mRightRate[n2];
            double d4 = (this.mDeltaTime * this.rate_bt1[n2] + 0.3125 * d3 + -0.1875 * d2 + -1.125 * d) / 0.1875;
            double d5 = d3 + d2 - 2.0 * d - 2.0 * d4;
            this.bt1_c4[n2] = d4;
            this.bt1_c3[n2] = d5;
            this.bt1_c2[n2] = d - d2 - d5 - d4;
            ++n2;
        }
    }
}

