/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;

public class EulerIntervalData
extends IntervalData {
    private double[] mLeftState;
    private double[] mLeftRate;

    public EulerIntervalData(double[] dArray, double[] dArray2, double d) {
        super(dArray[dArray.length - 1], d);
        int n = dArray.length;
        this.mLeftState = new double[n];
        this.mLeftRate = new double[n];
        System.arraycopy(dArray, 0, this.mLeftState, 0, n);
        System.arraycopy(dArray2, 0, this.mLeftRate, 0, n);
    }

    @Override
    public double interpolate(double d, int n) {
        double d2 = d - this.getLeft();
        return this.mLeftState[n] + d2 * this.mLeftRate[n];
    }

    @Override
    public double[] interpolate(double d, double[] dArray, int n, int n2) {
        double d2 = d - this.getLeft();
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            dArray[n4] = this.mLeftState[n3] + d2 * this.mLeftRate[n3];
            ++n3;
            ++n4;
        }
        return dArray;
    }
}

