/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;

public class HermiteIntervalData
extends IntervalData {
    protected int mTimeIndex;
    protected double mDeltaTime;
    protected double[] mLeftState;
    protected double[] mLeftRate;
    protected double[] mRightState;
    protected double[] mRightRate;

    public HermiteIntervalData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        super(dArray[dArray.length - 1], dArray3[dArray3.length - 1]);
        int n = dArray.length;
        this.mLeftState = new double[n];
        this.mRightState = new double[n];
        this.mLeftRate = new double[n];
        this.mRightRate = new double[n];
        System.arraycopy(dArray, 0, this.mLeftState, 0, n);
        System.arraycopy(dArray3, 0, this.mRightState, 0, n);
        System.arraycopy(dArray2, 0, this.mLeftRate, 0, n);
        System.arraycopy(dArray4, 0, this.mRightRate, 0, n);
        this.mTimeIndex = n - 1;
        this.mDeltaTime = dArray3[this.mTimeIndex] - dArray[this.mTimeIndex];
    }

    @Override
    public double interpolate(double d, int n) {
        double d2 = (d - this.getLeft()) / this.mDeltaTime;
        double d3 = d2 - 1.0;
        double d4 = d2 * d3;
        double d5 = d4 * (1.0 - 2.0 * d2);
        double d6 = -d3 - d5;
        double d7 = d2 + d5;
        double d8 = d4 * d3 * this.mDeltaTime;
        double d9 = d4 * d2 * this.mDeltaTime;
        return d6 * this.mLeftState[n] + d7 * this.mRightState[n] + d8 * this.mLeftRate[n] + d9 * this.mRightRate[n];
    }

    @Override
    public double[] interpolate(double d, double[] dArray, int n, int n2) {
        this.hermite((d - this.getLeft()) / this.mDeltaTime, dArray, n, n2);
        return dArray;
    }

    protected final void hermite(double d, double[] dArray, int n, int n2) {
        double d2 = d - 1.0;
        double d3 = d * d2;
        double d4 = d3 * (1.0 - 2.0 * d);
        double d5 = -d2 - d4;
        double d6 = d + d4;
        double d7 = d3 * d2 * this.mDeltaTime;
        double d8 = d3 * d * this.mDeltaTime;
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            dArray[n4] = d5 * this.mLeftState[n3] + d6 * this.mRightState[n3] + d7 * this.mLeftRate[n3] + d8 * this.mRightRate[n3];
            ++n3;
            ++n4;
        }
    }
}

