/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers;

import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolverException;
import org.opensourcephysics.numerics.ode_interpolation.EulerIntervalData;
import org.opensourcephysics.numerics.ode_interpolation.StateHistory;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;
import org.opensourcephysics.numerics.ode_solvers.Discontinuity;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.StateEvent;
import org.opensourcephysics.numerics.ode_solvers.ZenoEffectListener;

public class InterpolatorEventSolver {
    public static double EPSILON = 1.0;
    private boolean mEnableExceptions = true;
    protected boolean mUseBestInterpolation = false;
    private double mStepSize = 0.1;
    private double mAbsoluteTolerance = Double.NaN;
    private double mRelativeTolerance = Double.NaN;
    private double mMaxEventStep = Double.POSITIVE_INFINITY;
    private int mZenoMaximumAllowedTimes = 500;
    private double mProximityThreshold = 9.9E-324;
    private boolean mCoalesceCloseEvents = true;
    private int mMaxInternalSteps = 10000;
    protected SolverEngine mSolverEngine;
    protected ODE mODE;
    private boolean mRunsForwards = this.mStepSize > 0.0;
    private int mDimension;
    private int mTimeIndex;
    private ERROR mErrorCode = ERROR.NO_ERROR;
    private String mErrorMessage = "No error";
    private int mNumberOfAttempts = 0;
    private double[] mTest_ode_state;
    private double[] mIntermediate_ode_state;
    private List<EventData> mEventList = new ArrayList<EventData>();
    private List<EventData> mHappened = new ArrayList<EventData>();
    private List<EventData> mTemp_list = new ArrayList<EventData>();
    private double mLastEventDataTime = Double.NaN;
    private ProblemData mLastEventData = null;
    private int mZenoCounter = 0;
    private List<ZenoEffectListener> mZenoList = new ArrayList<ZenoEffectListener>();
    private ProblemData mCurrentEventData = null;
    private boolean mHasEventsOrDiscontinuities = false;
    private boolean mHasDiscontinuities = false;
    private DiscontinuityData mDiscontinuityAtEnd = null;
    private List<DiscontinuityData> mDiscontinuityList = new ArrayList<DiscontinuityData>();
    private DDEDiscontinuity mDDEdiscontinuity = null;
    private int mDDEdiscontinuityMaxIterations = 100;
    private double mDDEdiscontinuityTolerance = 1.0E-8;

    static {
        while (EPSILON + 1.0 != 1.0) {
            EPSILON /= 2.0;
        }
        EPSILON *= 2.0;
    }

    public InterpolatorEventSolver(SolverEngine solverEngine, ODE oDE) {
        this.mSolverEngine = solverEngine;
        this.mODE = oDE;
        if (this.mODE instanceof DelayDifferentialEquation) {
            this.mDDEdiscontinuity = new DDEDiscontinuity((DelayDifferentialEquation)this.mODE);
        }
        this.mSolverEngine.setODE(this, this.mODE);
    }

    public void setEnableExceptions(boolean bl) {
        this.mEnableExceptions = bl;
    }

    public void setBestInterpolation(boolean bl) {
        this.mUseBestInterpolation = bl;
    }

    public void setHistoryLength(double d) {
        this.mSolverEngine.getStateHistory().setLength(d);
    }

    public void setStepSize(double d) {
        if (this.mStepSize == d) {
            return;
        }
        this.mStepSize = d;
        this.mRunsForwards = this.mStepSize > 0.0;
        this.setInternalStepSize(this.mSolverEngine.getStepSize());
    }

    public double getStepSize() {
        return this.mStepSize;
    }

    public void setEstimateFirstStep(boolean bl) {
        this.mSolverEngine.setEstimateFirstStep(bl);
    }

    public void setInternalStepSize(double d) {
        this.mSolverEngine.setStepSize(this.mRunsForwards ? Math.abs(d) : -Math.abs(d));
    }

    public void setMaximumInternalStepSize(double d) {
        this.mSolverEngine.setMaximumStepSize(d);
    }

    public void setMaximumInternalSteps(int n) {
        this.mMaxInternalSteps = n;
    }

    public void setTolerances(double d, double d2) {
        this.mAbsoluteTolerance = Math.abs(d);
        this.mRelativeTolerance = Math.abs(d2);
        this.mSolverEngine.setTolerances(this.mAbsoluteTolerance, this.mRelativeTolerance);
    }

    public void setTolerance(double d) {
        this.setTolerances(d, 0.0);
    }

    public double getTolerance() {
        return Math.max(this.mAbsoluteTolerance, this.mRelativeTolerance);
    }

    public void setDDETolerance(double d) {
        this.mDDEdiscontinuityTolerance = d;
    }

    public double getDDETolerance() {
        return this.mDDEdiscontinuityTolerance;
    }

    public void setDDEIterations(int n) {
        this.mDDEdiscontinuityMaxIterations = n;
    }

    public int getDDEIterations() {
        return this.mDDEdiscontinuityMaxIterations;
    }

    public void addEvent(StateEvent stateEvent) {
        this.mEventList.add(new EventData(stateEvent, this.mODE.getState()));
        this.mHasEventsOrDiscontinuities = true;
    }

    public void removeEvent(StateEvent stateEvent) {
        EventData eventData = null;
        for (EventData eventData2 : this.mEventList) {
            if (eventData2.event != stateEvent) continue;
            eventData = eventData2;
            break;
        }
        if (eventData != null) {
            if (this.mLastEventData == eventData) {
                this.mLastEventData = null;
                this.mZenoCounter = 0;
            }
            if (this.mCurrentEventData == eventData) {
                this.mCurrentEventData = null;
            }
            this.mEventList.remove(eventData);
        }
        this.mHasEventsOrDiscontinuities = this.mHasDiscontinuities || !this.mEventList.isEmpty();
    }

    public void addDiscontinuity(Discontinuity discontinuity) {
        this.mDiscontinuityList.add(new DiscontinuityData(discontinuity, this.mODE.getState()));
        this.mHasDiscontinuities = true;
        this.mHasEventsOrDiscontinuities = true;
    }

    public void removeDiscontinuity(Discontinuity discontinuity) {
        DiscontinuityData discontinuityData = null;
        for (DiscontinuityData discontinuityData2 : this.mDiscontinuityList) {
            if (discontinuityData2.discontinuity != discontinuity) continue;
            discontinuityData = discontinuityData2;
            break;
        }
        if (discontinuityData != null) {
            this.mDiscontinuityList.remove(discontinuityData);
        }
        this.mHasDiscontinuities = !this.mDiscontinuityList.isEmpty();
        this.mHasEventsOrDiscontinuities = this.mHasDiscontinuities || !this.mEventList.isEmpty();
    }

    public void removeAllEvents() {
        this.mEventList.clear();
        this.mDiscontinuityList.clear();
        this.mHasDiscontinuities = false;
        this.mHasEventsOrDiscontinuities = false;
        if (this.mDDEdiscontinuity != null) {
            this.addDiscontinuity(this.mDDEdiscontinuity);
        }
    }

    public void setMaximumEventStep(double d) {
        this.mMaxEventStep = Math.abs(d);
    }

    public double getMaximumEventStep() {
        return this.mMaxEventStep;
    }

    public void setCoalesceCloseEvents(boolean bl) {
        this.mCoalesceCloseEvents = bl;
    }

    public boolean isCoalesceCloseEvents() {
        return this.mCoalesceCloseEvents;
    }

    public void setEventProximityThreshold(double d) {
        this.mProximityThreshold = d;
    }

    public double getEventProximityThreshold() {
        return this.mProximityThreshold;
    }

    public void setZenoEffectDetection(int n) {
        this.mZenoMaximumAllowedTimes = n;
    }

    public int getZenoEffectDetection() {
        return this.mZenoMaximumAllowedTimes;
    }

    public void addZenoEffectListener(ZenoEffectListener zenoEffectListener) {
        this.mZenoList.add(zenoEffectListener);
    }

    public void removeZenoEffectListener(ZenoEffectListener zenoEffectListener) {
        this.mZenoList.remove(zenoEffectListener);
    }

    public void setZeroZenoCounter() {
        this.mZenoCounter = 0;
    }

    public SolverEngine getSolverEngine() {
        return this.mSolverEngine;
    }

    public ODE getODE() {
        return this.mODE;
    }

    public StateHistory getStateHistory() {
        return this.mSolverEngine.getStateHistory();
    }

    public ERROR getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public long getCounter() {
        return this.mSolverEngine.getCounter();
    }

    public int getNumberOfAttempts() {
        return this.mNumberOfAttempts;
    }

    public double getInternalStepSize() {
        return this.mSolverEngine.getInternalStepSize();
    }

    public double getIndependentVariableValue() {
        return this.mODE.getState()[this.mTimeIndex];
    }

    public double getCurrentTime() {
        return this.mODE.getState()[this.mTimeIndex];
    }

    public void initialize(double d) {
        this.mStepSize = d;
        this.mRunsForwards = this.mStepSize > 0.0;
        this.mSolverEngine.initialize(this.mStepSize);
        double[] dArray = this.mODE.getState();
        this.mDimension = dArray.length;
        this.mTimeIndex = this.mDimension - 1;
        this.mTest_ode_state = new double[this.mDimension];
        this.mIntermediate_ode_state = new double[this.mDimension];
        this.mErrorCode = ERROR.NO_ERROR;
        this.mErrorMessage = "No error";
        this.mZenoCounter = 0;
        this.mLastEventData = null;
        this.mCurrentEventData = null;
        if (this.mDDEdiscontinuity != null) {
            this.mDDEdiscontinuity.initialize(dArray);
            this.removeDiscontinuity(this.mDDEdiscontinuity);
            this.addDiscontinuity(this.mDDEdiscontinuity);
        }
        for (EventData problemData : this.mEventList) {
            problemData.reset(dArray);
        }
        for (DiscontinuityData discontinuityData : this.mDiscontinuityList) {
            discontinuityData.reset(dArray);
        }
    }

    public double step() {
        if (this.mHasEventsOrDiscontinuities) {
            return this.stepWithEvents();
        }
        return this.stepWithoutEvents();
    }

    public double maxStep() {
        if (this.mHasEventsOrDiscontinuities) {
            return this.maxStepWithEvents();
        }
        return this.maxStepWithoutEvents();
    }

    public void userReinitialize() {
        this.mCurrentEventData = null;
        this.reinitialize();
    }

    public void reinitialize() {
        double[] dArray = this.mODE.getState();
        this.mSolverEngine.reinitialize(dArray);
        this.mErrorCode = ERROR.NO_ERROR;
        this.mErrorMessage = "No error";
        if (this.mDDEdiscontinuity != null) {
            this.mDDEdiscontinuity.reset(dArray);
        }
        for (EventData problemData : this.mEventList) {
            problemData.reset(dArray);
        }
        for (DiscontinuityData discontinuityData : this.mDiscontinuityList) {
            discontinuityData.reset(dArray);
        }
        this.mDiscontinuityAtEnd = null;
    }

    void resetDiscontinuities(double[] dArray) {
        if (this.mDDEdiscontinuity != null) {
            this.mDDEdiscontinuity.reset(dArray);
            for (DiscontinuityData discontinuityData : this.mDiscontinuityList) {
                discontinuityData.reset(dArray);
            }
        }
    }

    public DISCONTINUITY_CODE checkDiscontinuity(double[] dArray, boolean bl) {
        DiscontinuityData discontinuityData = null;
        block6: for (DiscontinuityData discontinuityData2 : this.mDiscontinuityList) {
            discontinuityData2.h = discontinuityData2.discontinuity.evaluate(dArray);
            switch (discontinuityData2.currentPosition) {
                default: {
                    if (discontinuityData2.h <= 0.0) {
                        return DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
                    }
                    if (!(discontinuityData2.h < discontinuityData2.discontinuity.getTolerance())) continue block6;
                    discontinuityData = discontinuityData2;
                    break;
                }
                case 1: {
                    if (!(discontinuityData2.h <= 0.0) || !discontinuityData2.positiveFlag) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + dArray[this.mTimeIndex] + " for the discontinuity " + discontinuityData2.discontinuity);
                    return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                }
                case 0: {
                    if (discontinuityData2.h < 0.0 && discontinuityData2.positiveFlag) {
                        this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + dArray[this.mTimeIndex] + " for the discontinuity " + discontinuityData2.discontinuity);
                        return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                    }
                    if (!(discontinuityData2.h > 0.0) || !discontinuityData2.negativeFlag) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + dArray[this.mTimeIndex] + " for the discontinuity " + discontinuityData2.discontinuity);
                    return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                }
                case -1: {
                    if (!discontinuityData2.negativeFlag || !(discontinuityData2.h >= 0.0)) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + dArray[this.mTimeIndex] + " for the discontinuity " + discontinuityData2.discontinuity);
                    return DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
                }
                case -2: {
                    if (discontinuityData2.h > 0.0) {
                        return DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
                    }
                    if (!(discontinuityData2.h > -discontinuityData2.discontinuity.getTolerance())) continue block6;
                    discontinuityData = discontinuityData2;
                }
            }
        }
        if (discontinuityData != null) {
            if (bl) {
                this.mDiscontinuityAtEnd = discontinuityData;
                this.mDiscontinuityAtEnd.time = dArray[this.mTimeIndex];
            }
            return DISCONTINUITY_CODE.DISCONTINUITY_EXACTLY_ON_STEP;
        }
        return DISCONTINUITY_CODE.NO_DISCONTINUITY_ALONG_STEP;
    }

    protected final void doTheInterpolation(double d, double[] dArray) {
        if (this.mUseBestInterpolation) {
            this.mSolverEngine.bestInterpolate(d, dArray);
        } else {
            this.mSolverEngine.interpolate(d, dArray);
        }
    }

    public double error(ERROR eRROR, String string) {
        this.mErrorCode = eRROR;
        this.mErrorMessage = string;
        if (this.mEnableExceptions) {
            throw new ODESolverException(this.mSolverEngine + ":\n" + string);
        }
        OSPLog.warning(string);
        return Double.NaN;
    }

    private final double maxStepWithoutEvents() {
        double[] dArray;
        double[] dArray2 = this.mODE.getState();
        double d = dArray2[this.mTimeIndex];
        if (d + (dArray = this.mSolverEngine.getCurrentRate())[this.mTimeIndex] == d) {
            return 0.0;
        }
        double d2 = this.mSolverEngine.getMaximumTime(false);
        if (Double.isNaN(d2)) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + dArray2[this.mTimeIndex]);
        }
        if (d == d2 && Double.isNaN(d2 = this.mSolverEngine.internalStep(false))) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at max step at " + dArray2[this.mTimeIndex]);
        }
        this.doTheInterpolation(d2, dArray2);
        return d2 - d;
    }

    /*
     * Unable to fully structure code
     */
    private double stepWithoutEvents() {
        block6: {
            var1_1 = this.mODE.getState();
            var3_3 = var1_1[this.mTimeIndex];
            if (var3_3 + (var2_2 = this.mSolverEngine.getCurrentRate())[this.mTimeIndex] == var3_3) {
                return 0.0;
            }
            var5_4 = var1_1[this.mTimeIndex] + this.mStepSize;
            var7_5 = this.mSolverEngine.getMaximumTime(false);
            if (Double.isNaN(var7_5)) {
                return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + var1_1[this.mTimeIndex]);
            }
            var9_6 = 0;
            if (!this.mRunsForwards) ** GOTO lbl25
            while (var7_5 < var5_4) {
                var7_5 = this.mSolverEngine.internalStep(false);
                if (Double.isNaN(var7_5)) {
                    return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver forwards at " + var1_1[this.mTimeIndex]);
                }
                if (++var9_6 <= this.mMaxInternalSteps) continue;
                var10_7 = var1_1[this.mTimeIndex];
                var12_8 = this.mSolverEngine.bestInterpolate(var5_4, new double[this.mDimension])[this.mTimeIndex];
                return this.error(ERROR.TOO_MANY_STEPS_ERROR, "The solver exceeded the maximum of " + this.mMaxInternalSteps + " internal steps\nat " + var12_8 + ", starting from " + var10_7 + " for an step of " + this.mStepSize);
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                var7_5 = this.mSolverEngine.internalStep(false);
                if (Double.isNaN(var7_5)) {
                    return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver backwards at " + var1_1[this.mTimeIndex]);
                }
                if (++var9_6 <= this.mMaxInternalSteps) continue;
                return this.error(ERROR.TOO_MANY_STEPS_ERROR, "The solver exceeded the number of internal steps at " + var1_1[this.mTimeIndex]);
lbl25:
                // 2 sources

                ** while (var7_5 > var5_4)
            }
        }
        this.doTheInterpolation(var5_4, var1_1);
        return this.mStepSize;
    }

    private final double maxStepWithEvents() {
        ProblemData problemData;
        double[] dArray = this.mODE.getState();
        if (this.mZenoMaximumAllowedTimes > 0 && this.mZenoCounter > this.mZenoMaximumAllowedTimes && this.callZenoAction(dArray)) {
            return 0.0;
        }
        double d = dArray[this.mTimeIndex];
        double[] dArray2 = this.mSolverEngine.getCurrentRate();
        if (d + dArray2[this.mTimeIndex] == d) {
            return 0.0;
        }
        double d2 = this.mSolverEngine.getMaximumTime(this.mHasDiscontinuities);
        if (Double.isNaN(d2)) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + dArray[this.mTimeIndex]);
        }
        if (d == d2 && Double.isNaN(d2 = this.mSolverEngine.internalStep(this.mHasDiscontinuities))) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver forwards at " + dArray[this.mTimeIndex]);
        }
        if (this.mLastEventData != null && !Double.isNaN(this.mLastEventData.getMaxAdvance())) {
            d2 = this.mRunsForwards ? Math.min(d2, this.mLastEventData.getMaxAdvance()) : Math.max(d2, this.mLastEventData.getMaxAdvance());
        }
        double d3 = this.mRunsForwards ? Math.min(d + this.mMaxEventStep, d2) : Math.max(d - this.mMaxEventStep, d2);
        while (true) {
            problemData = null;
            this.mCurrentEventData = null;
            this.doTheInterpolation(d3, this.mTest_ode_state);
            problemData = this.findFirstEvent(dArray, d3, this.mTest_ode_state);
            if (problemData == null && this.mDiscontinuityAtEnd != null && this.mDiscontinuityAtEnd.time <= d3) {
                problemData = this.mDiscontinuityAtEnd;
            }
            if (problemData != null) break;
            if (d3 == d2) {
                System.arraycopy(this.mTest_ode_state, 0, dArray, 0, this.mDimension);
                this.updateEventsAndDiscontinuities(dArray[this.mTimeIndex]);
                return d2 - d;
            }
            d3 = this.mRunsForwards ? Math.min(d3 + this.mMaxEventStep, d2) : Math.max(d3 - this.mMaxEventStep, d2);
        }
        this.mCurrentEventData = problemData;
        if (this.mUseBestInterpolation) {
            this.mSolverEngine.bestInterpolate(problemData.getTime(), dArray);
        } else {
            System.arraycopy(this.mTest_ode_state, 0, dArray, 0, this.mDimension);
        }
        double d4 = dArray[this.mTimeIndex];
        problemData.action();
        this.reinitialize();
        dArray = this.mODE.getState();
        if (d4 != dArray[this.mTimeIndex]) {
            this.mZenoCounter = 0;
            this.mLastEventData = null;
            this.mCurrentEventData = null;
            problemData.reset(dArray);
            return problemData.getTime() - d;
        }
        if (this.mLastEventData != null) {
            this.mZenoCounter = Math.abs(this.mLastEventDataTime - problemData.getTime()) < this.mProximityThreshold ? ++this.mZenoCounter : 0;
        }
        this.mLastEventData = problemData;
        this.mLastEventDataTime = problemData.getTime();
        return problemData.getTime() - d;
    }

    private double stepWithEvents() {
        double[] dArray = this.mODE.getState();
        if (this.mZenoMaximumAllowedTimes > 0 && this.mZenoCounter > this.mZenoMaximumAllowedTimes && this.callZenoAction(dArray)) {
            return 0.0;
        }
        double d = dArray[this.mTimeIndex];
        double[] dArray2 = this.mSolverEngine.getCurrentRate();
        if (d + dArray2[this.mTimeIndex] == d) {
            return 0.0;
        }
        double d2 = d + this.mStepSize;
        double d3 = this.mSolverEngine.getMaximumTime(this.mHasDiscontinuities);
        if (Double.isNaN(d3)) {
            return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver at " + dArray[this.mTimeIndex]);
        }
        double d4 = this.mRunsForwards ? Math.min(d + this.mMaxEventStep, d2) : Math.max(d - this.mMaxEventStep, d2);
        int n = 0;
        while (true) {
            boolean bl;
            ProblemData problemData = null;
            this.mCurrentEventData = null;
            boolean bl2 = this.mRunsForwards ? d3 < d4 : (bl = d3 > d4);
            if (bl) {
                this.mSolverEngine.bestInterpolate(d3, this.mTest_ode_state);
                problemData = this.findFirstEvent(dArray, d3, this.mTest_ode_state);
                if (problemData == null) {
                    problemData = this.mDiscontinuityAtEnd;
                }
                if (problemData == null) {
                    System.arraycopy(this.mTest_ode_state, 0, dArray, 0, this.mDimension);
                    this.updateEventsAndDiscontinuities(dArray[this.mTimeIndex]);
                    d3 = this.mSolverEngine.internalStep(this.mHasDiscontinuities);
                    if (Double.isNaN(d3)) {
                        return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver looking for an event at " + dArray[this.mTimeIndex]);
                    }
                    if (++n <= this.mMaxInternalSteps) continue;
                    return this.error(ERROR.TOO_MANY_STEPS_ERROR, "The solver exceeded the number of internal steps at " + dArray[this.mTimeIndex]);
                }
            } else {
                this.doTheInterpolation(d4, this.mTest_ode_state);
                problemData = this.findFirstEvent(dArray, d4, this.mTest_ode_state);
                if (problemData == null && this.mDiscontinuityAtEnd != null && this.mDiscontinuityAtEnd.time <= d4) {
                    problemData = this.mDiscontinuityAtEnd;
                }
                if (problemData == null) {
                    if (d4 == d2) {
                        System.arraycopy(this.mTest_ode_state, 0, dArray, 0, this.mDimension);
                        this.updateEventsAndDiscontinuities(dArray[this.mTimeIndex]);
                        return d2 - d;
                    }
                    d4 = this.mRunsForwards ? Math.min(d4 + this.mMaxEventStep, d2) : Math.max(d4 - this.mMaxEventStep, d2);
                    continue;
                }
            }
            this.mCurrentEventData = problemData;
            if (this.mUseBestInterpolation) {
                this.mSolverEngine.bestInterpolate(problemData.getTime(), dArray);
            } else {
                System.arraycopy(this.mTest_ode_state, 0, dArray, 0, this.mDimension);
            }
            double d5 = dArray[this.mTimeIndex];
            boolean bl3 = problemData.action();
            this.reinitialize();
            n = 0;
            dArray = this.mODE.getState();
            if (d5 != dArray[this.mTimeIndex]) {
                this.mZenoCounter = 0;
                this.mLastEventData = null;
                this.mCurrentEventData = null;
                problemData.reset(dArray);
                return problemData.getTime() - d;
            }
            if (this.mLastEventData != null) {
                if (Math.abs(this.mLastEventDataTime - problemData.getTime()) < this.mProximityThreshold) {
                    ++this.mZenoCounter;
                    if (this.mCoalesceCloseEvents) {
                        bl3 = false;
                    }
                } else {
                    this.mZenoCounter = 0;
                }
            }
            this.mLastEventData = problemData;
            this.mLastEventDataTime = problemData.getTime();
            if (bl3) {
                return problemData.getTime() - d;
            }
            if (this.mZenoMaximumAllowedTimes > 0 && this.mZenoCounter > this.mZenoMaximumAllowedTimes && this.callZenoAction(dArray)) {
                return problemData.getTime() - d;
            }
            this.mDiscontinuityAtEnd = null;
            d3 = this.mSolverEngine.getMaximumTime(this.mHasDiscontinuities);
            if (!Double.isNaN(problemData.getMaxAdvance())) {
                double d6 = d3 = this.mRunsForwards ? Math.min(d3, problemData.getMaxAdvance()) : Math.max(d3, problemData.getMaxAdvance());
            }
            if (Double.isNaN(d3)) break;
        }
        return this.error(ERROR.INTERNAL_SOLVER_ERROR, "Error when stepping the solver after an event at " + dArray[this.mTimeIndex]);
    }

    private void updateEventsAndDiscontinuities(double d) {
        for (EventData problemData : this.mEventList) {
            problemData.findPosition(d, problemData.h);
        }
        for (DiscontinuityData discontinuityData : this.mDiscontinuityList) {
            discontinuityData.findPosition(d, discontinuityData.h);
        }
    }

    private boolean callZenoAction(double[] dArray) {
        if (this.mZenoList.isEmpty()) {
            this.error(ERROR.ZENO_EFFECT, "A Zeno-like effect has been detected.\nLast event was " + this.mLastEventData.getProblem() + " which took place at " + this.mLastEventDataTime);
            return true;
        }
        boolean bl = false;
        for (ZenoEffectListener zenoEffectListener : this.mZenoList) {
            if (!zenoEffectListener.zenoEffectAction(this.mLastEventData.getProblem(), dArray)) continue;
            bl = true;
        }
        this.mZenoCounter = 0;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private EventData findFirstEvent(double[] dArray, double d, double[] dArray2) {
        EventData eventData32;
        this.mNumberOfAttempts = 0;
        EventData eventData2 = this.happensRightNow(dArray[this.mTimeIndex], dArray2, this.mHappened, "at t1");
        if (eventData2 != null) {
            eventData2.time = dArray[this.mTimeIndex];
            eventData2.maxAdvance = d;
            System.arraycopy(dArray, 0, dArray2, 0, this.mDimension);
            return eventData2;
        }
        if (this.mHappened.isEmpty()) {
            return null;
        }
        boolean bl = true;
        for (EventData eventData32 : this.mEventList) {
            eventData32.hAfter = eventData32.h;
        }
        block1: while (bl) {
            ++this.mNumberOfAttempts;
            double d2 = this.nextPointToCheck(this.mHappened, dArray[this.mTimeIndex], d);
            this.doTheInterpolation(d2, this.mIntermediate_ode_state);
            EventData eventData4 = this.happensRightNow(dArray[this.mTimeIndex], this.mIntermediate_ode_state, this.mTemp_list, "short");
            if (eventData4 != null) {
                eventData4.time = dArray[this.mTimeIndex];
                eventData4.maxAdvance = d2;
                System.arraycopy(dArray, 0, dArray2, 0, this.mDimension);
                return eventData4;
            }
            if (this.mTemp_list.isEmpty()) {
                EventData eventData5 = null;
                for (EventData eventData : this.mHappened) {
                    if (eventData.currentPosition == 2) {
                        if (!(eventData.h < eventData.event.getTolerance())) continue;
                        eventData5 = eventData;
                        break;
                    }
                    if (!(eventData.h > -eventData.event.getTolerance())) continue;
                    eventData5 = eventData;
                    break;
                }
                if (eventData5 != null) {
                    eventData5.time = d2;
                    eventData5.maxAdvance = d;
                    System.arraycopy(this.mIntermediate_ode_state, 0, dArray2, 0, this.mDimension);
                    return eventData5;
                }
                System.arraycopy(this.mIntermediate_ode_state, 0, dArray, 0, this.mDimension);
                for (EventData eventData : this.mEventList) {
                    eventData.findPosition(dArray[this.mTimeIndex], eventData.h);
                }
                EventData eventData = this.happensRightNow(dArray[this.mTimeIndex], dArray2, this.mHappened, "at tTest");
                if (eventData != null) {
                    eventData.time = dArray[this.mTimeIndex];
                    eventData.maxAdvance = d;
                    System.arraycopy(dArray, 0, dArray2, 0, this.mDimension);
                    return eventData;
                }
            } else {
                void var11_20;
                boolean bl2 = true;
                Object var11_19 = null;
                for (EventData eventData : this.mTemp_list) {
                    if (eventData.currentPosition == 2) {
                        if (eventData.h <= -eventData.event.getTolerance()) {
                            bl2 = false;
                            break;
                        }
                        EventData eventData5 = eventData;
                        continue;
                    }
                    if (eventData.h >= eventData.event.getTolerance()) {
                        bl2 = false;
                        break;
                    }
                    EventData eventData6 = eventData;
                }
                if (bl2 && var11_20 != null) {
                    var11_20.time = d2;
                    var11_20.maxAdvance = d;
                    System.arraycopy(this.mIntermediate_ode_state, 0, dArray2, 0, this.mDimension);
                    return var11_20;
                }
                d = d2;
                System.arraycopy(this.mIntermediate_ode_state, 0, dArray2, 0, this.mDimension);
                for (EventData eventData : this.mEventList) {
                    eventData.hAfter = eventData.h;
                }
                this.mHappened.clear();
                this.mHappened.addAll(this.mTemp_list);
            }
            for (EventData eventData6 : this.mHappened) {
                if (this.mNumberOfAttempts <= eventData6.event.getMaxIterations()) continue;
                bl = false;
                continue block1;
            }
        }
        eventData32 = this.mHappened.get(0);
        this.error(ERROR.EVENT_NOT_FOUND, "Warning : Event not found after " + this.mNumberOfAttempts + " attempts at t=" + dArray[this.mTimeIndex] + " h = " + eventData32.h + ".\nPlease check the code of your event, decrease the initial step size, the tolerance of the solver," + "\nor the event maximum step, or increase the maximum number of attempts." + "\nFirst event remaining in the queue: " + eventData32.event);
        eventData32.time = (dArray[this.mTimeIndex] + d) / 2.0;
        eventData32.maxAdvance = Double.NaN;
        this.mSolverEngine.bestInterpolate(eventData32.time, dArray2);
        return eventData32;
    }

    private EventData happensRightNow(double d, double[] dArray, List<EventData> list, String string) {
        list.clear();
        block6: for (EventData eventData : this.mEventList) {
            eventData.h = eventData.event.evaluate(dArray);
            switch (eventData.currentPosition) {
                default: {
                    if (!(eventData.h <= 0.0)) continue block6;
                    list.add(eventData);
                    break;
                }
                case 1: {
                    if (!(eventData.h <= 0.0) || !eventData.positiveFlag && eventData.eventType != 0) continue block6;
                    return eventData;
                }
                case 0: {
                    if (!(eventData.h < 0.0 ? eventData.positiveFlag || eventData.eventType == 0 : eventData.h > 0.0 && eventData.negativeFlag && eventData.eventType == 2)) continue block6;
                    return eventData;
                }
                case -1: {
                    if (!(eventData.eventType == 0 ? eventData.h <= -eventData.event.getTolerance() : eventData.eventType == 2 && eventData.negativeFlag && eventData.h >= 0.0)) continue block6;
                    return eventData;
                }
                case -2: {
                    if (eventData.eventType == 2) {
                        if (!(eventData.h >= 0.0)) continue block6;
                        list.add(eventData);
                        break;
                    }
                    if (eventData.eventType != 0) continue block6;
                    this.error(ERROR.ILLEGAL_EVENT_STATE, "The system started from an illegal state at " + d + " for the state event " + eventData.event);
                    return eventData;
                }
            }
        }
        return null;
    }

    private double nextPointToCheck(List<EventData> list, double d, double d2) {
        double d3 = d2;
        double d4 = d2 - d;
        double d5 = (d + d2) / 2.0;
        if (this.mRunsForwards) {
            for (EventData eventData : list) {
                switch (eventData.event.getRootFindingMethod()) {
                    default: {
                        d3 = Math.min(d3, d5);
                        break;
                    }
                    case 1: {
                        d3 = Math.min(d3, d - eventData.hBefore * d4 / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        } else {
            for (EventData eventData : list) {
                switch (eventData.event.getRootFindingMethod()) {
                    default: {
                        d3 = Math.max(d3, d5);
                        break;
                    }
                    case 1: {
                        d3 = Math.max(d3, d - eventData.hBefore * d4 / (eventData.hAfter - eventData.hBefore));
                    }
                }
            }
        }
        return d3;
    }

    static /* synthetic */ int access$7(InterpolatorEventSolver interpolatorEventSolver) {
        return interpolatorEventSolver.mDDEdiscontinuityMaxIterations;
    }

    private class DDEDiscontinuity
    implements Discontinuity {
        DelayDifferentialEquation mDDE;
        List<Double> mDiscontinuities = new ArrayList<Double>();
        int[] mDiIndex;
        double[] mRateForCorrections;

        private DDEDiscontinuity(DelayDifferentialEquation delayDifferentialEquation) {
            this.mDDE = delayDifferentialEquation;
        }

        private void initialize(double[] dArray) {
            if (InterpolatorEventSolver.this.mRunsForwards) {
                this.mDiscontinuities.add(Double.NEGATIVE_INFINITY);
            } else {
                this.mDiscontinuities.add(Double.POSITIVE_INFINITY);
            }
            double[] dArray2 = this.mDDE.getInitialConditionDiscontinuities();
            if (dArray2 != null) {
                double[] dArray3 = dArray2;
                int n = dArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    double d = dArray3[n2];
                    this.mDiscontinuities.add(d);
                    ++n2;
                }
            }
            this.mDiscontinuities.add(dArray[InterpolatorEventSolver.this.mTimeIndex]);
            double[] dArray4 = this.mDDE.getDelays(dArray);
            this.mDiIndex = new int[dArray4.length];
            this.reset(dArray);
            this.mRateForCorrections = new double[InterpolatorEventSolver.this.mDimension];
        }

        void reset(double[] dArray) {
            int n = 0;
            while (n < this.mDiIndex.length) {
                this.mDiIndex[n] = 0;
                ++n;
            }
            this.update(dArray);
        }

        private void update(double[] dArray) {
            double[] dArray2 = this.mDDE.getDelays(dArray);
            int n = dArray2.length;
            int n2 = this.mDiscontinuities.size();
            if (InterpolatorEventSolver.this.mRunsForwards) {
                int n3 = 0;
                while (n3 < n) {
                    double d = dArray[InterpolatorEventSolver.this.mTimeIndex] - dArray2[n3] + this.getTolerance();
                    int n4 = this.mDiIndex[n3];
                    while (n4 < n2) {
                        double d2 = this.mDiscontinuities.get(n4);
                        if (d2 > d) {
                            this.mDiIndex[n3] = n4;
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                int n5 = 0;
                while (n5 < n) {
                    double d = dArray[InterpolatorEventSolver.this.mTimeIndex] - dArray2[n5] - this.getTolerance();
                    int n6 = this.mDiIndex[n5];
                    while (n6 < n2) {
                        double d3 = this.mDiscontinuities.get(n6);
                        if (d3 < d) {
                            this.mDiIndex[n5] = n6;
                            break;
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }

        @Override
        public double evaluate(double[] dArray) {
            double d = dArray[InterpolatorEventSolver.this.mTimeIndex];
            double[] dArray2 = this.mDDE.getDelays(dArray);
            int n = dArray2.length;
            if (InterpolatorEventSolver.this.mRunsForwards) {
                double d2 = Double.POSITIVE_INFINITY;
                int n2 = 0;
                while (n2 < n) {
                    double d3 = this.mDiscontinuities.get(this.mDiIndex[n2]);
                    d2 = Math.min(d2, dArray2[n2] + d3 - d);
                    ++n2;
                }
                return d2;
            }
            double d4 = Double.NEGATIVE_INFINITY;
            int n3 = 0;
            while (n3 < n) {
                double d5 = this.mDiscontinuities.get(this.mDiIndex[n3]);
                d4 = Math.max(d4, dArray2[n3] + d5 - d);
                ++n3;
            }
            return d4;
        }

        /*
         * Unable to fully structure code
         */
        private double correctTime(double[] var1_1) {
            block4: {
                var2_2 = InterpolatorEventSolver.access$6(InterpolatorEventSolver.this) / 20.0;
                var4_3 = 0;
                if (!InterpolatorEventSolver.access$4(InterpolatorEventSolver.this)) ** GOTO lbl28
                while (++var4_3 < InterpolatorEventSolver.access$7(InterpolatorEventSolver.this)) {
                    this.mDDE.getRate(var1_1, this.mRateForCorrections);
                    InterpolatorEventSolver.this.mSolverEngine.getStateHistory().addIntervalData(new EulerIntervalData(var1_1, this.mRateForCorrections, var1_1[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)] + var2_2));
                    var5_5 = 0;
                    while (var5_5 < InterpolatorEventSolver.access$5(InterpolatorEventSolver.this)) {
                        v0 = var5_5;
                        var1_1[v0] = var1_1[v0] + var2_2 * this.mRateForCorrections[var5_5];
                        ++var5_5;
                    }
                    var5_4 = this.evaluate(var1_1);
                    if (!(var5_4 < 0.0)) continue;
                    return var1_1[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)];
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    this.mDDE.getRate(var1_1, this.mRateForCorrections);
                    InterpolatorEventSolver.this.mSolverEngine.getStateHistory().addIntervalData(new EulerIntervalData(var1_1, this.mRateForCorrections, var1_1[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)] - var2_2));
                    var5_7 = 0;
                    while (var5_7 < InterpolatorEventSolver.access$5(InterpolatorEventSolver.this)) {
                        v1 = var5_7;
                        var1_1[v1] = var1_1[v1] - var2_2 * this.mRateForCorrections[var5_7];
                        ++var5_7;
                    }
                    var5_6 = this.evaluate(var1_1);
                    if (!(var5_6 > 0.0)) continue;
                    return var1_1[InterpolatorEventSolver.access$0(InterpolatorEventSolver.this)];
lbl28:
                    // 2 sources

                    ** while (++var4_3 < InterpolatorEventSolver.access$7((InterpolatorEventSolver)InterpolatorEventSolver.this))
                }
            }
            return NaN;
        }

        @Override
        public boolean action() {
            double[] dArray = this.mDDE.getState();
            double d = this.correctTime(dArray);
            this.mDiscontinuities.add(d);
            EventData eventData = InterpolatorEventSolver.this.findFirstEvent(dArray, d, dArray);
            if (eventData != null) {
                InterpolatorEventSolver.this.mCurrentEventData = eventData;
                eventData.action();
            }
            return true;
        }

        @Override
        public double getTolerance() {
            return InterpolatorEventSolver.this.mDDEdiscontinuityTolerance;
        }
    }

    public static enum DISCONTINUITY_CODE {
        DISCONTINUITY_PRODUCED_ERROR,
        NO_DISCONTINUITY_ALONG_STEP,
        DISCONTINUITY_ALONG_STEP,
        DISCONTINUITY_JUST_PASSED,
        DISCONTINUITY_EXACTLY_ON_STEP;

    }

    private class DiscontinuityData
    implements ProblemData {
        Discontinuity discontinuity;
        boolean positiveFlag;
        boolean negativeFlag;
        int currentPosition;
        double hBefore;
        double h;
        double time;

        DiscontinuityData(Discontinuity discontinuity, double[] dArray) {
            this.discontinuity = discontinuity;
            this.reset(dArray);
        }

        @Override
        public double getTime() {
            return this.time;
        }

        @Override
        public double getMaxAdvance() {
            return Double.NaN;
        }

        @Override
        public boolean action() {
            return this.discontinuity.action();
        }

        @Override
        public Object getProblem() {
            return this.discontinuity;
        }

        @Override
        public void reset(double[] dArray) {
            this.negativeFlag = false;
            this.positiveFlag = false;
            double d = this.discontinuity.evaluate(dArray);
            this.findPosition(dArray[InterpolatorEventSolver.this.mTimeIndex], d);
            if (InterpolatorEventSolver.this.mCurrentEventData != this) {
                if (d > 0.0) {
                    this.positiveFlag = true;
                } else if (d < 0.0) {
                    this.negativeFlag = true;
                }
            }
        }

        @Override
        public void findPosition(double d, double d2) {
            this.hBefore = d2;
            if (this.hBefore >= this.discontinuity.getTolerance()) {
                this.currentPosition = 2;
                this.positiveFlag = true;
            } else if (this.hBefore > 0.0) {
                this.currentPosition = 1;
            } else if (this.hBefore == 0.0) {
                this.currentPosition = 0;
            } else if (this.hBefore > -this.discontinuity.getTolerance()) {
                this.currentPosition = -1;
            } else {
                this.currentPosition = -2;
                this.negativeFlag = true;
            }
        }
    }

    public static enum ERROR {
        NO_ERROR,
        INTERNAL_SOLVER_ERROR,
        EVENT_NOT_FOUND,
        ILLEGAL_EVENT_STATE,
        ZENO_EFFECT,
        TOO_MANY_STEPS_ERROR,
        DISCONTINUITY_PRODUCED_ERROR,
        DID_NOT_CONVERGE;

    }

    private class EventData
    implements ProblemData {
        StateEvent event;
        boolean positiveFlag;
        boolean negativeFlag;
        final int eventType;
        int currentPosition;
        double hBefore;
        double hAfter;
        double h;
        double time;
        double maxAdvance;

        EventData(StateEvent stateEvent, double[] dArray) {
            this.event = stateEvent;
            this.eventType = this.event.getTypeOfEvent();
            this.reset(dArray);
        }

        @Override
        public double getTime() {
            return this.time;
        }

        @Override
        public double getMaxAdvance() {
            return this.maxAdvance;
        }

        @Override
        public boolean action() {
            return this.event.action();
        }

        @Override
        public Object getProblem() {
            return this.event;
        }

        @Override
        public void reset(double[] dArray) {
            this.negativeFlag = false;
            this.positiveFlag = false;
            double d = this.event.evaluate(dArray);
            this.findPosition(dArray[InterpolatorEventSolver.this.mTimeIndex], d);
            if (InterpolatorEventSolver.this.mCurrentEventData != this) {
                if (this.eventType == 2) {
                    if (d > 0.0) {
                        this.positiveFlag = true;
                    } else if (d < 0.0) {
                        this.negativeFlag = true;
                    }
                } else if (this.eventType == 1 && d > 0.0) {
                    this.positiveFlag = true;
                }
            }
        }

        @Override
        public void findPosition(double d, double d2) {
            this.hBefore = d2;
            if (this.hBefore >= this.event.getTolerance()) {
                this.currentPosition = 2;
                this.positiveFlag = true;
            } else if (this.hBefore > 0.0) {
                this.currentPosition = 1;
            } else if (this.hBefore == 0.0) {
                this.currentPosition = 0;
            } else if (this.hBefore > -this.event.getTolerance()) {
                this.currentPosition = -1;
            } else {
                this.currentPosition = -2;
                this.negativeFlag = true;
            }
            if (this.eventType == 0 && this.currentPosition == -2) {
                String string = "The state event " + this.event + " is in an illegal state: " + this.hBefore + " at " + d;
                string = InterpolatorEventSolver.this.mLastEventData == null ? String.valueOf(string) + "\nThere was no previous event" : String.valueOf(string) + "\nLast previous event was " + InterpolatorEventSolver.this.mLastEventData.getProblem() + ", which took place at " + InterpolatorEventSolver.this.mLastEventDataTime;
                InterpolatorEventSolver.this.error(ERROR.ILLEGAL_EVENT_STATE, string);
            }
        }
    }

    private static interface ProblemData {
        public static final int POSITIVE = 2;
        public static final int SMALL_POSITIVE = 1;
        public static final int ZERO = 0;
        public static final int SMALL_NEGATIVE = -1;
        public static final int NEGATIVE = -2;

        public void reset(double[] var1);

        public void findPosition(double var1, double var3);

        public double getTime();

        public double getMaxAdvance();

        public boolean action();

        public Object getProblem();
    }
}

