/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_interpolation.StateHistory;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;

public abstract class SolverEngineDiscreteTime
implements SolverEngine {
    protected InterpolatorEventSolver.ERROR mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
    protected int mDimension;
    protected int mTimeIndex;
    protected long mAccumulatedEvaluations = 0L;
    protected double mStepSize = 0.1;
    protected double mMaximumStepSize = Double.POSITIVE_INFINITY;
    protected double mInitialTime = 0.0;
    protected double mFinalTime = 0.0;
    protected double[] mInitialState;
    protected double[] mInitialRate;
    protected double[] mFinalState;
    protected double[] mFinalRate;
    protected ODE mODE;
    protected InterpolatorEventSolver mEventSolver;
    protected StateHistory mStateHistory;

    protected abstract int getNumberOfEvaluations();

    protected abstract void allocateOtherArrays();

    protected abstract void computeIntermediateStep(double var1, double[] var3);

    protected abstract InterpolatorEventSolver.DISCONTINUITY_CODE computeIntermediateStep(InterpolatorEventSolver var1, double var2, double[] var4);

    protected abstract IntervalData computeFinalRateAndCreateIntervalData();

    @Override
    public void setODE(InterpolatorEventSolver interpolatorEventSolver, ODE oDE) {
        this.mEventSolver = interpolatorEventSolver;
        this.mODE = oDE;
        double[] dArray = this.mODE.getState();
        this.mDimension = dArray.length;
        this.mTimeIndex = this.mDimension - 1;
        this.mStateHistory = new StateHistory(oDE);
        if (this.mODE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation delayDifferentialEquation = (DelayDifferentialEquation)this.mODE;
            this.mStateHistory.setMinimumLength(delayDifferentialEquation.getMaximumDelay());
        }
    }

    @Override
    public final void initialize(double d) {
        this.mStepSize = d;
        double[] dArray = this.mODE.getState();
        if (this.mInitialState == null || this.mInitialState.length != dArray.length) {
            this.mDimension = dArray.length;
            this.mTimeIndex = this.mDimension - 1;
            this.mInitialState = new double[this.mDimension];
            this.mInitialRate = new double[this.mDimension];
            this.mFinalState = new double[this.mDimension];
            this.mFinalRate = new double[this.mDimension];
            this.allocateOtherArrays();
        }
        this.mAccumulatedEvaluations = 0L;
        this.mStateHistory.clearAll();
        if (this.mODE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation delayDifferentialEquation = (DelayDifferentialEquation)this.mODE;
            this.mStateHistory.setMinimumLength(Math.max(Math.abs(delayDifferentialEquation.getMaximumDelay()), Math.abs(d)));
        } else {
            this.mStateHistory.setMinimumLength(d);
        }
        this.reinitialize(dArray);
    }

    @Override
    public void reinitialize(double[] dArray) {
        this.mInitialTime = dArray[this.mTimeIndex];
        System.arraycopy(dArray, 0, this.mInitialState, 0, this.mDimension);
        this.mODE.getRate(this.mInitialState, this.mInitialRate);
        ++this.mAccumulatedEvaluations;
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
    }

    @Override
    public double[] getCurrentRate() {
        return this.mInitialRate;
    }

    @Override
    public final void setStepSize(double d) {
        this.mStepSize = d;
        if (this.mODE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation delayDifferentialEquation = (DelayDifferentialEquation)this.mODE;
            this.mStateHistory.setMinimumLength(Math.max(Math.abs(delayDifferentialEquation.getMaximumDelay()), Math.abs(d)));
        } else {
            this.mStateHistory.setMinimumLength(d);
        }
    }

    @Override
    public void setMaximumStepSize(double d) {
        this.mMaximumStepSize = Math.abs(d);
    }

    @Override
    public final double getStepSize() {
        return this.mStepSize;
    }

    @Override
    public final double getInternalStepSize() {
        return this.mFinalTime - this.mInitialTime;
    }

    @Override
    public void setEstimateFirstStep(boolean bl) {
    }

    @Override
    public void setTolerances(double d, double d2) {
    }

    @Override
    public final double getMaximumTime(boolean bl) {
        if (this.mErrorCode != InterpolatorEventSolver.ERROR.NO_ERROR) {
            return Double.NaN;
        }
        if (Double.isNaN(this.mFinalTime)) {
            this.computeOneStep(bl);
        }
        return this.mFinalTime;
    }

    @Override
    public final double internalStep(boolean bl) {
        this.mInitialTime = this.mFinalTime;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        System.arraycopy(this.mFinalState, 0, this.mInitialState, 0, this.mDimension);
        System.arraycopy(this.mFinalRate, 0, this.mInitialRate, 0, this.mDimension);
        this.computeOneStep(bl);
        return this.mFinalTime;
    }

    @Override
    public final long getCounter() {
        return this.mAccumulatedEvaluations;
    }

    @Override
    public StateHistory getStateHistory() {
        return this.mStateHistory;
    }

    @Override
    public double[] interpolate(double d, double[] dArray) {
        return this.mStateHistory.interpolate(d, dArray);
    }

    @Override
    public double[] bestInterpolate(double d, double[] dArray) {
        if (Double.isNaN(this.mFinalTime)) {
            return null;
        }
        if (d == this.mFinalTime) {
            System.arraycopy(this.mFinalState, 0, dArray, 0, this.mDimension);
            return dArray;
        }
        if (d == this.mInitialTime) {
            System.arraycopy(this.mInitialState, 0, dArray, 0, this.mDimension);
            return dArray;
        }
        this.computeIntermediateStep(d - this.mInitialTime, dArray);
        return dArray;
    }

    protected double getActualStepSize() {
        return this.mStepSize;
    }

    protected double findTheDiscontinuity(double d) {
        int n = 0;
        double d2 = 0.0;
        double d3 = d;
        int n2 = this.mEventSolver.getDDEIterations();
        while (n < n2) {
            if (Math.abs(d2 - d3) < InterpolatorEventSolver.EPSILON) break;
            double d4 = (d2 + d3) / 2.0;
            switch (this.computeIntermediateStep(this.mEventSolver, d4, this.mFinalState)) {
                default: {
                    return Double.NaN;
                }
                case NO_DISCONTINUITY_ALONG_STEP: {
                    d2 = d4;
                    break;
                }
                case DISCONTINUITY_EXACTLY_ON_STEP: {
                    return this.mFinalState[this.mTimeIndex];
                }
                case DISCONTINUITY_JUST_PASSED: {
                    d3 -= (d3 - d2) / 4.0;
                    break;
                }
                case DISCONTINUITY_ALONG_STEP: {
                    d3 = d4;
                }
            }
            ++n;
        }
        this.computeIntermediateStep(this.mEventSolver, d2, this.mFinalState);
        return this.mFinalState[this.mTimeIndex];
    }

    protected void computeOneStep(boolean bl) {
        double d = this.mStepSize;
        if (bl) {
            switch (this.computeIntermediateStep(this.mEventSolver, d, this.mFinalState)) {
                case DISCONTINUITY_PRODUCED_ERROR: {
                    this.mFinalTime = Double.NaN;
                    return;
                }
                case NO_DISCONTINUITY_ALONG_STEP: 
                case DISCONTINUITY_EXACTLY_ON_STEP: {
                    this.mFinalTime = this.mFinalState[this.mTimeIndex];
                    break;
                }
                case DISCONTINUITY_ALONG_STEP: 
                case DISCONTINUITY_JUST_PASSED: {
                    this.mFinalTime = this.findTheDiscontinuity(d);
                }
            }
            if (Double.isNaN(this.mFinalTime)) {
                this.mErrorCode = InterpolatorEventSolver.ERROR.DISCONTINUITY_PRODUCED_ERROR;
                return;
            }
        } else {
            this.computeIntermediateStep(d, this.mFinalState);
            this.mFinalTime = this.mFinalState[this.mTimeIndex];
        }
        this.mAccumulatedEvaluations += (long)this.getNumberOfEvaluations();
        this.mStateHistory.clean(this.mInitialTime);
        this.mStateHistory.addIntervalData(this.computeFinalRateAndCreateIntervalData());
    }
}

