/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers.rk;

import org.opensourcephysics.numerics.ode_interpolation.BootstrapIntervalData;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngineDiscreteTime;

public class RK4
extends SolverEngineDiscreteTime {
    private double[] mRate2;
    private double[] mRate3;
    private double[] mRate4;

    @Override
    protected int getNumberOfEvaluations() {
        return 4;
    }

    @Override
    protected void allocateOtherArrays() {
        this.mRate2 = new double[this.mDimension];
        this.mRate3 = new double[this.mDimension];
        this.mRate4 = new double[this.mDimension];
    }

    @Override
    protected void computeIntermediateStep(double d, double[] dArray) {
        double d2 = d / 2.0;
        double d3 = this.mInitialRate[this.mTimeIndex];
        int n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d2 * this.mInitialRate[n];
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate2);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d2 * this.mRate2[n];
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate3);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * this.mRate3[n];
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate4);
        n = 0;
        while (n < this.mTimeIndex) {
            dArray[n] = this.mInitialState[n] + d * (this.mInitialRate[n] + 2.0 * this.mRate2[n] + 2.0 * this.mRate3[n] + this.mRate4[n]) / 6.0;
            ++n;
        }
        dArray[this.mTimeIndex] = this.mInitialTime + d * d3;
    }

    @Override
    protected InterpolatorEventSolver.DISCONTINUITY_CODE computeIntermediateStep(InterpolatorEventSolver interpolatorEventSolver, double d, double[] dArray) {
        double d2 = d / 2.0;
        double d3 = this.mInitialRate[this.mTimeIndex];
        int n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d2 * this.mInitialRate[n];
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate2);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d2 * this.mRate2[n];
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate3);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * this.mRate3[n];
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate4);
        n = 0;
        while (n < this.mTimeIndex) {
            dArray[n] = this.mInitialState[n] + d * (this.mInitialRate[n] + 2.0 * this.mRate2[n] + 2.0 * this.mRate3[n] + this.mRate4[n]) / 6.0;
            ++n;
        }
        dArray[this.mTimeIndex] = this.mInitialTime + d * d3;
        return interpolatorEventSolver.checkDiscontinuity(dArray, true);
    }

    @Override
    protected IntervalData computeFinalRateAndCreateIntervalData() {
        this.mODE.getRate(this.mFinalState, this.mFinalRate);
        return new BootstrapIntervalData(this.mInitialState, this.mInitialRate, this.mFinalState, this.mFinalRate, this.mODE);
    }
}

